﻿using System;
using Microsoft.CSharp.RuntimeBinder;

namespace OrdinaryTypes
{
    class Program
    {
        static void Main(string[] args)
        {
            try
            {
                // Listing 18-11. Używanie prostego obiektu za pośrednictwem zmiennej typu dynamic
                dynamic a = new MyType { Text = "Jeden", Number = 123 };
                Console.WriteLine(a.Text);
                Console.WriteLine(a.Number);
                Console.WriteLine(a.Problem);
            }
            catch (RuntimeBinderException)
            {
                Console.WriteLine("Wyjątek zostaje zgłoszony zgodnie z przewidywaniami");
            }

            {
                // Listing 18-12. Przypisywanie wartości właściwościom i wywoływanie metod przy użyciu typu dynamicznego
                dynamic a = new MyType();
                a.Number = 42;
                a.Text = "Foo";
                Console.WriteLine(a);
                dynamic b = new MyType();
                b.SetBoth("Bar", 99);
                Console.WriteLine(b);

                // Listing 18-13. Używanie przeładowanego operatora +
                MyType c = AddAnything(a, b);
                Console.WriteLine(c);
            }
        }

        static dynamic AddAnything(dynamic a, dynamic b)
        {
            dynamic result = a + b;
            Console.WriteLine(result);
            return result;
        }
    }
}
